package com.example.sefinsa_app.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Model Prestamo
 * */
public class Prestamo implements Parcelable {

    private String id, cliente_id, nombre_completo, direccion_cliente, telefono_cliente, garantias, ruta_id, poblacion_id, colocadora_id, aval_id, grupo_poblacion,
    monto_prestado, pago_semanal, fecha_prestamo, modalidad_semanas, numero_tarjeton, status, comentario, comentario_fecha,
    nombre_aval, direccion_aval, telefono_aval, garantias_aval, or_aval, nombre_ruta, nombre_poblacion, semanas, monto_multa,
            es_semana_14, es_semana_19, tiene_pendientes, tiene_multas, tiene_folios, latitud, longitud, tipo_pago, nombre_colocadora, update_comprobantes_cliente, update_garantias_cliente, update_comprobantes_aval, update_garantias_aval, created_at, updated_at;

    private boolean isSelected = false, isSelectedPagar = false, isSelectedPagarConMulta = false, isSelectedNoPagar = false, isSelectedAdelantar = false;

    protected Prestamo(Parcel in) {
        id = in.readString();
        cliente_id = in.readString();
        nombre_completo = in.readString();
        direccion_cliente = in.readString();
        telefono_cliente = in.readString();
        garantias = in.readString();
        ruta_id = in.readString();
        poblacion_id = in.readString();
        colocadora_id = in.readString();
        aval_id = in.readString();
        grupo_poblacion = in.readString();
        monto_prestado = in.readString();
        pago_semanal = in.readString();
        fecha_prestamo = in.readString();
        modalidad_semanas = in.readString();
        numero_tarjeton = in.readString();
        status = in.readString();
        comentario = in.readString();
        comentario_fecha = in.readString();
        nombre_aval = in.readString();
        direccion_aval = in.readString();
        telefono_aval = in.readString();
        garantias_aval = in.readString();
        or_aval = in.readString();
        nombre_ruta = in.readString();
        nombre_poblacion = in.readString();
        semanas = in.readString();
        monto_multa = in.readString();
        isSelected = in.readByte() != 0;
        nombre_colocadora = in.readString();
        update_comprobantes_cliente = in.readString();
        update_garantias_cliente = in.readString();
        update_comprobantes_aval = in.readString();
        update_garantias_aval = in.readString();
    }
    public Prestamo() {

    }
    public Prestamo(String id, String cliente_id, String direccion_cliente, String telefono_cliente, String ruta_id, String poblacion_id, String colocadora_id, String aval_id, String grupo_poblacion, String monto_prestado, String pago_semanal, String fecha_prestamo, String modalidad_semanas, String numero_tarjeton, String status) {
        this.id = id;
        this.cliente_id = cliente_id;
        this.direccion_cliente = direccion_cliente;
        this.telefono_cliente = telefono_cliente;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.colocadora_id = colocadora_id;
        this.aval_id = aval_id;
        this.grupo_poblacion = grupo_poblacion;
        this.monto_prestado = monto_prestado;
        this.pago_semanal = pago_semanal;
        this.fecha_prestamo = fecha_prestamo;
        this.modalidad_semanas = modalidad_semanas;
        this.numero_tarjeton = numero_tarjeton;
        this.status = status;
    }

    public Prestamo(String id, String cliente_id, String direccion_cliente, String telefono_cliente, String ruta_id, String poblacion_id, String colocadora_id, String aval_id, String grupo_poblacion, String monto_prestado, String pago_semanal, String fecha_prestamo, String modalidad_semanas, String numero_tarjeton, String status, String created_at, String updated_at) {
        this.id = id;
        this.cliente_id = cliente_id;
        this.direccion_cliente = direccion_cliente;
        this.telefono_cliente = telefono_cliente;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.colocadora_id = colocadora_id;
        this.aval_id = aval_id;
        this.grupo_poblacion = grupo_poblacion;
        this.monto_prestado = monto_prestado;
        this.pago_semanal = pago_semanal;
        this.fecha_prestamo = fecha_prestamo;
        this.modalidad_semanas = modalidad_semanas;
        this.numero_tarjeton = numero_tarjeton;
        this.status = status;
        this.created_at = created_at;
        this.updated_at = updated_at;
    }

    public Prestamo(String id, String numero_tarjeton, String updated_at) {
        this.id = id;
        this.numero_tarjeton = numero_tarjeton;
        this.updated_at = updated_at;
    }
    public Prestamo(String id, String numero_tarjeton, String created_at, String updated_at, String aval_id) {
        this.id = id;
        this.numero_tarjeton = numero_tarjeton;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.aval_id = aval_id;
    }
    public Prestamo(String id, String cliente_id, String nombre_completo, String direccion_cliente,
                    String telefono_cliente, String garantias,
                    String status, String fecha_prestamo, String monto_prestado, String nombre_colocadora,
                    String nombre_aval, String direccion_aval, String telefono_aval, String nombre_ruta,
                    String nombre_poblacion, String monto_multa, String semanas, String es_semana_14,
                    String es_semana_19, String tiene_pendientes, String tiene_multas, String tiene_folios,
                    String created_at, String updated_at, String numero_tarjeton, String grupo, String garantias_aval, String or_aval, String pago_semanal, String ruta_id, String poblacion_id, String modalidad_semanas, String aval_id) {
        this.id = id;
        this.cliente_id = cliente_id;
        this.nombre_completo = nombre_completo;
        this.direccion_cliente = direccion_cliente;
        this.telefono_cliente = telefono_cliente;
        this.garantias = garantias;
        this.status = status;
        this.fecha_prestamo = fecha_prestamo;
        this.monto_prestado = monto_prestado;
        this.nombre_colocadora = nombre_colocadora;
        this.nombre_aval = nombre_aval;
        this.direccion_aval = direccion_aval;
        this.telefono_aval = telefono_aval;
        this.nombre_ruta = nombre_ruta;
        this.nombre_poblacion = nombre_poblacion;
        this.monto_multa = monto_multa;
        this.semanas = semanas;
        this.es_semana_14 = es_semana_14;
        this.es_semana_19 = es_semana_19;
        this.tiene_pendientes = tiene_pendientes;
        this.tiene_multas = tiene_multas;
        this.tiene_folios = tiene_folios;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.numero_tarjeton = numero_tarjeton;
        this.garantias_aval = garantias_aval;
        this.or_aval = or_aval;
        this.grupo_poblacion = grupo;
        this.pago_semanal = pago_semanal;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.modalidad_semanas = modalidad_semanas;
        this.aval_id = aval_id;
    }

    public String getLatitud() {
        return latitud;
    }

    public void setLatitud(String latitud) {
        this.latitud = latitud;
    }

    public String getLongitud() {
        return longitud;
    }

    public void setLongitud(String longitud) {
        this.longitud = longitud;
    }

    public String getTiene_folios() {
        return tiene_folios;
    }

    public void setTiene_folios(String tiene_folios) {
        this.tiene_folios = tiene_folios;
    }

    public String getTiene_pendientes() {
        return tiene_pendientes;
    }

    public void setTiene_pendientes(String tiene_pendientes) {
        this.tiene_pendientes = tiene_pendientes;
    }


    public String getCreated_at() {
        return created_at;
    }

    public void setCreated_at(String created_at) {
        this.created_at = created_at;
    }

    public String getUpdated_at() {
        return updated_at;
    }

    public void setUpdated_at(String updated_at) {
        this.updated_at = updated_at;
    }


    public String getTiene_multas() {
        return tiene_multas;
    }

    public void setTiene_multas(String tiene_multas) {
        this.tiene_multas = tiene_multas;
    }

    public String getEs_semana_14() {
        return es_semana_14;
    }

    public void setEs_semana_14(String es_semana_14) {
        this.es_semana_14 = es_semana_14;
    }

    public String getEs_semana_19() {
        return es_semana_19;
    }

    public void setEs_semana_19(String es_semana_19) {
        this.es_semana_19 = es_semana_19;
    }

    public static final Creator<Prestamo> CREATOR = new Creator<Prestamo>() {
        @Override
        public Prestamo createFromParcel(Parcel in) {
            return new Prestamo(in);
        }

        @Override
        public Prestamo[] newArray(int size) {
            return new Prestamo[size];
        }
    };

    public String getMonto_multa() {
        return monto_multa;
    }

    public void setMonto_multa(String monto_multa) {
        this.monto_multa = monto_multa;
    }

    public String getGarantias() {
        return garantias;
    }

    public void setGarantias(String garantias) {
        this.garantias = garantias;
    }

    public void setSelected(boolean selected) {
        isSelected = selected;
    }

    public boolean isSelected() {
        return isSelected;
    }

    public void setSelectedPagar(boolean selected) {
        isSelectedPagar = selected;
    }
    public boolean isSelectedPagar() {
        return isSelectedPagar;
    }

    public void setSelectedPagarConMulta(boolean selected) {
        isSelectedPagarConMulta = selected;
    }
    public boolean isSelectedPagarConMulta() {
        return isSelectedPagarConMulta;
    }

    public void setSelectedAdelantar(boolean selected) {
        isSelectedAdelantar = selected;
    }
    public boolean isSelectedAdelantar() {
        return isSelectedAdelantar;
    }

    public void setSelectedNoPagar(boolean selected) {
        isSelectedNoPagar = selected;
    }
    public boolean isSelectedNoPagar() {
        return isSelectedNoPagar;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCliente_id() {
        return cliente_id;
    }

    public void setCliente_id(String cliente_id) {
        this.cliente_id = cliente_id;
    }

    public String getDireccion_cliente() {
        return direccion_cliente;
    }

    public void setDireccion_cliente(String direccion_cliente) {
        this.direccion_cliente = direccion_cliente;
    }

    public String getTelefono_cliente() {
        return telefono_cliente;
    }

    public void setTelefono_cliente(String telefono_cliente) {
        this.telefono_cliente = telefono_cliente;
    }

    public String getRuta_id() {
        return ruta_id;
    }

    public void setRuta_id(String ruta_id) {
        this.ruta_id = ruta_id;
    }

    public String getPoblacion_id() {
        return poblacion_id;
    }

    public void setPoblacion_id(String poblacion_id) {
        this.poblacion_id = poblacion_id;
    }

    public String getColocadora_id() {
        return colocadora_id;
    }

    public void setColocadora_id(String colocadora_id) {
        this.colocadora_id = colocadora_id;
    }

    public String getAval_id() {
        return aval_id;
    }

    public void setAval_id(String aval_id) {
        this.aval_id = aval_id;
    }

    public String getGrupo_poblacion() {
        return grupo_poblacion;
    }

    public void setGrupo_poblacion(String grupo_poblacion) {
        this.grupo_poblacion = grupo_poblacion;
    }

    public String getMonto_prestado() {
        return monto_prestado;
    }

    public void setMonto_prestado(String monto_prestado) {
        this.monto_prestado = monto_prestado;
    }

    public String getPago_semanal() {
        return pago_semanal;
    }

    public void setPago_semanal(String pago_semanal) {
        this.pago_semanal = pago_semanal;
    }

    public String getFecha_prestamo() {
        return fecha_prestamo;
    }

    public String getNombre_completo() {
        return nombre_completo;
    }

    public void setNombre_completo(String nombre_completo) {
        this.nombre_completo = nombre_completo;
    }

    public void setFecha_prestamo(String fecha_prestamo) {
        this.fecha_prestamo = fecha_prestamo;
    }

    public String getModalidad_semanas() {
        return modalidad_semanas;
    }

    public void setModalidad_semanas(String modalidad_semanas) {
        this.modalidad_semanas = modalidad_semanas;
    }

    public String getNumero_tarjeton() {
        return numero_tarjeton;
    }

    public void setNumero_tarjeton(String numero_tarjeton) {
        this.numero_tarjeton = numero_tarjeton;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getComentario() {
        return comentario;
    }

    public void setComentario(String comentario) {
        this.comentario = comentario;
    }

    public String getComentario_fecha() {
        return comentario_fecha;
    }

    public void setComentario_fecha(String comentario_fecha) {
        this.comentario_fecha = comentario_fecha;
    }

    public String getNombre_aval() {
        return nombre_aval;
    }

    public void setNombre_aval(String nombre_aval) {
        this.nombre_aval = nombre_aval;
    }

    public String getNombre_colocadora() {
        return nombre_colocadora;
    }

    public void setNombre_colocadora(String nombre_colocadora) {
        this.nombre_colocadora = nombre_colocadora;
    }

    public String getDireccion_aval() {
        return direccion_aval;
    }


    public String getUpdate_comprobantes_cliente() {
        return update_comprobantes_cliente;
    }
    public void setUpdate_comprobantes_cliente(String update_comprobantes_cliente) {
        this.update_comprobantes_cliente = update_comprobantes_cliente;
    }
    public String getUpdate_garantias_cliente() {
        return update_garantias_cliente;
    }
    public void setUpdate_garantias_cliente(String update_garantias_cliente) {
        this.update_garantias_cliente = update_garantias_cliente;
    }

    public String getUpdate_garantias_aval() {
        return update_garantias_aval;
    }
    public void setUpdate_garantias_aval(String update_garantias_aval) {
        this.update_garantias_aval = update_garantias_aval;
    }
    public String getUpdate_comprobantes_aval() {
        return update_comprobantes_aval;
    }
    public void setUpdate_comprobantes_aval(String update_comprobantes_aval) {
        this.update_comprobantes_aval = update_comprobantes_aval;
    }

    public void setDireccion_aval(String direccion_aval) {
        this.direccion_aval = direccion_aval;
    }

    public String getTelefono_aval() {
        return telefono_aval;
    }

    public void setTelefono_aval(String telefono_aval) {
        this.telefono_aval = telefono_aval;
    }

    public String getGarantias_aval() {
        return garantias_aval;
    }

    public void setGarantias_aval(String garantias_aval) {
        this.garantias_aval = garantias_aval;
    }

    public String getOr_aval() {
        return or_aval;
    }

    public void setOr_aval(String or_aval) {
        this.or_aval = or_aval;
    }

    public String getNombre_ruta() {
        return nombre_ruta;
    }

    public void setNombre_ruta(String nombre_ruta) {
        this.nombre_ruta = nombre_ruta;
    }

    public String getNombre_poblacion() {
        return nombre_poblacion;
    }

    public void setNombre_poblacion(String nombre_poblacion) {
        this.nombre_poblacion = nombre_poblacion;
    }

    public String getSemanas() {
        return semanas;
    }

    public void setSemanas(String semanas) {
        this.semanas = semanas;
    }

    @Override
    public String toString() {
        return this.numero_tarjeton;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(id);
        parcel.writeString(cliente_id);
        parcel.writeString(nombre_completo);
        parcel.writeString(direccion_cliente);
        parcel.writeString(telefono_cliente);
        parcel.writeString(garantias);
        parcel.writeString(ruta_id);
        parcel.writeString(poblacion_id);
        parcel.writeString(colocadora_id);
        parcel.writeString(aval_id);
        parcel.writeString(grupo_poblacion);
        parcel.writeString(monto_prestado);
        parcel.writeString(pago_semanal);
        parcel.writeString(fecha_prestamo);
        parcel.writeString(modalidad_semanas);
        parcel.writeString(numero_tarjeton);
        parcel.writeString(status);
        parcel.writeString(comentario);
        parcel.writeString(comentario_fecha);
        parcel.writeString(nombre_aval);
        parcel.writeString(direccion_aval);
        parcel.writeString(telefono_aval);
        parcel.writeString(garantias_aval);
        parcel.writeString(or_aval);
        parcel.writeString(nombre_ruta);
        parcel.writeString(nombre_poblacion);
        parcel.writeString(semanas);
        parcel.writeString(monto_multa);
        parcel.writeByte((byte) (isSelected ? 1 : 0));
        parcel.writeString(tipo_pago);
        parcel.writeString(nombre_colocadora);
    }
}
